<?php
/* 
    Plugin Name: SEOAnalyzer
    Plugin URI: http://codecanyon.net/item/seoanalyzer/13395656
    Description: More then 20 Metrics to Measure & Track Success of your SEO Strategy. No need to check SEO stats on different websites and tools. Just one website One tool.
    Author: zhan.shatmanov
    Version: 1.3.5
    Author URI: https://shatmanov.com 
*/
/* define( 'WP_DEBUG', true );
 ini_set('display_errors', '1');
 ini_set('error_reporting', E_ALL);*/
// Stop direct call
if(preg_match('#' . basename(__FILE__) . '#', $_SERVER['PHP_SELF'])) { die('You are not allowed to call this page directly.'); }

	define('W3TC_DYNAMIC_SECURITY', 'mysecretcode');
	
	$plugin_dir = basename(dirname(__FILE__));
    load_plugin_textdomain('seoanalyzer', false, "$plugin_dir/lang");
	add_action('plugins_loaded', 'SEOmo');
	function SEOmo(){
    	$mo_file_path = dirname(__FILE__) . '/lang/seoanalyzer-'. get_locale() . '.mo';
    	load_textdomain('seoanalyzer', $mo_file_path );
	}
	
	// Если мы в адм. интерфейсе
	if ( is_admin() ) {
		add_action('admin_menu', 'seoanalyzer_admin_menu');	
		add_action('admin_init', 'register_seoanalyzerSettings');		
	} else {
		// Добавляем стили и скрипты
		add_action('wp_print_scripts', 'seoanalyzer_scripts');
		add_action('wp_print_styles', 'seoanalyzer_styles');
		
		add_action('wp_head', 'SEO_head');
		add_action('wp_footer', 'SEO_footer');
	}
	
	function seoanalyzer_admin_menu(){
		$page = add_menu_page(__('SEOAnalyzer', 'seoanalyzer'), __('SEOAnalyzer', 'seoanalyzer'), 'edit_users', 'seoanalyzer', 'seoanalyzer_config', 'dashicons-chart-area');
		
		add_action('admin_print_styles-' . $page, 'SEOAnalyzer_admin_styles');
    }
	
	function SEOAnalyzer_admin_styles(){
        /*
         * Эта функция будет вызвана только на странице плагина, 
           поставим наш стиль в очередь здесь */
        wp_enqueue_style('SEO_CSS_admin');
    }
	
	function register_seoanalyzerSettings() {
		register_setting( 'seoanalyzer-settings-group', 'addthis_api' );
		register_setting( 'seoanalyzer-settings-group', 'google_api' );
		register_setting( 'seoanalyzer-settings-group', 'google_cx' );
		register_setting( 'seoanalyzer-settings-group', 'tracking_code' );
		register_setting( 'seoanalyzer-settings-group', 'upd_SEO_info' );
		register_setting( 'seoanalyzer-settings-group', 'SEO_mainmenu' );
		register_setting( 'seoanalyzer-settings-group', 'SEO_Mimg' );
		register_setting( 'seoanalyzer-settings-group', 'SEO_wcc' );
		register_setting( 'seoanalyzer-settings-group', 'css_template' );
		register_setting( 'seoanalyzer-settings-group', 'SEO_shortcodes' );
		register_setting( 'seoanalyzer-settings-group', 'SEO_shortcodes_page' );
		
		wp_register_style('SEO_CSS_admin', SEO_ANALYZER_THEMES_URL.'/include/css/main.css');
	}
	
	//Plugin Menu Link
	function seoanalyzer_action_links( $links ) {
		$links[] = '<a href="'. admin_url( 'admin.php?page=seoanalyzer' ) .'">'.__( 'Settings', 'seoanalyzer' ).'</a>';
		$links[] = '<a href="'. admin_url( 'admin.php?page=seoanalyzer&amp;tab=help' ) .'">'.__( 'Help', 'seoanalyzer' ).'</a>';
		return $links;
	}
	#plugin page links
	add_filter('plugin_action_links_'.plugin_basename( __FILE__ ), 'seoanalyzer_action_links' );
	
	function seoanalyzer_config(){
		echo '<h1>'.__( 'SEOAnalyzer', 'seoanalyzer' ).'</h1>';
		if(isset($_GET['tab'])&&!empty($_GET['tab'])) {
			$tab_var = $_GET['tab'];
		}else{
			$tab_var = '';
		}
?>
        
        <div class="wp-filter">
        	<ul class="filter-links">
        		<li><a href="admin.php?page=seoanalyzer"<?php if (empty($tab_var)){echo ' class="current"';} ?>><?php echo __( 'General settings', 'seoanalyzer' ); ?></a></li>
        		<li><a href="admin.php?page=seoanalyzer&amp;tab=sites"<?php if ($tab_var=='sites'){echo ' class="current"';} ?>><?php echo __( 'Websites', 'seoanalyzer' ); ?></a> </li>
        		<li><a href="admin.php?page=seoanalyzer&amp;tab=help"<?php if ($tab_var=='help'){echo ' class="current"';} ?>><?php echo __( 'Help', 'seoanalyzer' ); ?></a> </li>
        	</ul>
        </div>
<?php
		
		$tab = isset($_GET['tab']) ? $_GET['tab'] : null ;
		switch ($tab) {
		
			case 'sites':
				include_once('include/sites.php');		
			break;
			
			case 'help':
				include_once('include/help.php');		
			break;
					
			default:
				include_once('include/main.php');
		}
		
	}
	
	//Функции SEO
	require("functions/functions.php");
	require("functions/addtobd.php");
	require("services/whoisClass.php");
	require("services/cy.php");
	require("services/alexaRank.php");
	require("services/smm.php");
	require("services/cat.php");
	require("services/seo.php");
	require("services/header.php");

if(get_option('SEO_shortcodes')){
	//включены
	add_shortcode( 'seoanalyzer', 'seoanalyzer_embed_shortcode');
	add_filter( 'template_include', 'SEOtheme_shortcode' );
}else{
	add_filter( 'template_include', 'SEOtheme' );
}

add_filter('body_class','SEO_class');
function SEO_class($classes) {
	$classes[] = 'loading';
	return $classes;
}


define( 'SEO_ANALYZER_THEMES_URL', WP_PLUGIN_URL.'/'.basename(dirname(__FILE__)) ); //Путь до папки с темой 
define( 'SEO_ANALYZER_INC_URL', plugin_dir_path( __FILE__ ) ); //Путь до папки с темой 

	function seoanalyzer_scripts(){
		wp_register_script('SEO_JS', SEO_ANALYZER_THEMES_URL.'/theme/js/main.js');
		wp_register_script('SEO_JS_sweetalert', SEO_ANALYZER_THEMES_URL.'/theme/js/bootstrap.min.js');
		if(get_option('SEO_shortcodes_page')&&is_page(get_option('SEO_shortcodes_page'))){
			wp_enqueue_script('SEO_JS');
			wp_enqueue_script('SEO_JS_sweetalert');
		}
    }
	
	function seoanalyzer_styles(){
		wp_register_style('SEO_CSS_main', SEO_ANALYZER_THEMES_URL.'/shortcode/css/main.css');
		$style = get_option('css_template');
		if(empty($style)){
			$style = 'default.css';
		}
		wp_register_style('SEO_CSS_theme', SEO_ANALYZER_THEMES_URL.'/theme/css/template/'.$style);
		wp_register_style('SEO_CSS_rtl', SEO_ANALYZER_THEMES_URL.'/theme/css/rtl.css');
		wp_register_style('SEO_CSS_awesome', SEO_ANALYZER_THEMES_URL.'/theme/css/font-awesome.css');
		wp_register_style('SEO_CSS_sweetalert', SEO_ANALYZER_THEMES_URL.'/theme/css/sweetalert.css');
		
		if(get_option('SEO_shortcodes_page')&&is_page(get_option('SEO_shortcodes_page'))){
			wp_enqueue_style('SEO_CSS_main');
			wp_enqueue_style('SEO_CSS_theme');
			if (apply_filters('wpml_is_rtl', false)){
				wp_enqueue_style('SEO_CSS_rtl');
			}
			wp_enqueue_style('SEO_CSS_awesome');
			wp_enqueue_style('SEO_CSS_sweetalert');
		}
    }
	
	function SEO_head(){	
		if(get_option('SEO_shortcodes_page')&&is_page(get_option('SEO_shortcodes_page'))){
?>
<script type="text/javascript">
function Rotator(start_from){
    var phrases = [
		"<?php echo __( 'Check domain', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking WHOIS', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Determining the age of a domain', 'seoanalyzer' ); ?>",
		"<?php echo __( 'We are looking for meta tags', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking Robot.txt', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking XML Sitemap', 'seoanalyzer' ); ?>",
		"<?php echo __( 'We are looking for errors', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Determination CMS', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Determination IP', 'seoanalyzer' ); ?>",
		"<?php echo __( 'We are looking for DNS', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Determination server', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Determination location', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking indicators on search engines', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking catalogs', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking PageRank', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking CY', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking Alexa Rank', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Checking social activity', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Making a screenshot', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Saving information', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Clearing the cache', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Creating page', 'seoanalyzer' ); ?>",
		"<?php echo __( 'Loading page', 'seoanalyzer' ); ?>"
	];
    var total=phrases.length;var interval=6000;var randomz=Math.floor(Math.random()*total);if(void 0===start_from){start_from=0}jQuery("#loadingtext").text(phrases[start_from]).animate({"opacity":"1"},1000,function(){if(start_from>=(total-1)){setTimeout(function(){jQuery("#loadingtext").animate({"opacity":"0"},1000,function(){Rotator()})},interval)}else{start_from++;setTimeout(function(){jQuery("#loadingtext").animate({"opacity":"0"},1000,function(){Rotator(start_from)})},interval)}})
}
</script>
<?php
		}
	}
	
	function SEO_footer(){	
		if(get_option('SEO_shortcodes_page')&&is_page(get_option('SEO_shortcodes_page'))){
?>
    <div id="load_container">
    	<div class="SEOAnalyzerloader">
        	<div class="SEOAnalyzerspinner"><div class="SEOAnalyzerrect1"></div><div class="SEOAnalyzerrect2"></div><div class="SEOAnalyzerrect3"></div><div class="SEOAnalyzerrect4"></div><div class="SEOAnalyzerrect5"></div></div>
            <div id="loadingtext"><?php echo __( 'Loading', 'seoanalyzer' ); ?></div>
    	</div>
    </div>
<?php
		}
	}

function SEOtheme($template) {
	if(is_404()){
		return plugin_dir_path( __FILE__ ).'/theme/404.php';
	}else if(is_home()){
		return plugin_dir_path( __FILE__ ).'/theme/index.php';
	}else if(is_single()) {
		return plugin_dir_path( __FILE__ ).'/theme/single.php';
	}else if(is_page()) {
		return plugin_dir_path( __FILE__ ).'/theme/page.php';
	}else if(is_archive()) {
		return plugin_dir_path( __FILE__ ).'/theme/archive.php';
	}else{
    	return $template;
	}
}

function SEOtheme_shortcode($template) {
	if(get_option('SEO_shortcodes_page')&&is_page(get_option('SEO_shortcodes_page'))){
		return plugin_dir_path( __FILE__ ).'/shortcode/index.php';
	}else{
    	return $template;
	}
}

function SEOtheme_dont_cache() {
	global $wpdb, $current_blog;
	if($wpdb->blogid = get_option('SEO_shortcodes_page')) {
		define('DONOTCACHEPAGE', true );
		define('DONOTCACHEDB', true);
	}
}

add_action("init", "SEOtheme_dont_cache");

function seoanalyzer_embed_shortcode($atts){
	include_once('shortcode/index.php');		
}

//добавляем ЧПУ
function SEOtheme_rewrite_rule(){
	add_rewrite_tag('%seourl%', '([^&]+)');
	add_rewrite_rule(
		'^seo/([^/]*)$',
		'index.php?seourl=$matches[1]',
		'top'
	);
	add_rewrite_rule(
		'(.*?)seo/([^/]*)$',
		'index.php?seourl=$matches[2]',
		'top'
	);
	flush_rewrite_rules();
}

function SEOshortcode_rewrite_rule(){
	$user_slug = get_post(get_option('SEO_shortcodes_page'))->post_name;
	$SEO_shortcodes_page = get_option('SEO_shortcodes_page');
	add_rewrite_tag('%seourl%', '([^&]+)');
	add_rewrite_rule(
		'^'.$user_slug.'/seo/([^/]*)$',
		'index.php?page_id='.$SEO_shortcodes_page.'&seourl=$matches[1]',
		'top'
	);
	flush_rewrite_rules();
}	
	
if(get_option('SEO_shortcodes')){
	//включены
	if(get_option('SEO_shortcodes_page')){
		add_action('init', 'SEOshortcode_rewrite_rule');
	}
}else{
	add_action('init', 'SEOtheme_rewrite_rule');
}
	
//Чистим папку cache
	function SEOanalyzer_cron() {
		function myscandir($dir){
			$list = scandir($dir);
			unset($list[0],$list[1]);
			return array_values($list);
		}
				//function cleaning folder
		function clear_dir($dir){
			$list = myscandir($dir);
			foreach ($list as $file){
				if (is_dir($dir.$file)){
					clear_dir($dir.$file.'/');
					rmdir($dir.$file);
				}else{
					unlink($dir.$file);
				}
			}
		}
		clear_dir(SEO_ANALYZER_INC_URL.'/cache/');
		
	}


/**
* Активация плагина
*/
	function SEOAnalyzer_activate(){
		include_once('functions/activate.php');
		wp_schedule_event(time(), 'daily', 'SEOanalyzer_cron_twicedaily');
	}
	register_activation_hook( __FILE__, 'SEOAnalyzer_activate' );	

/**
* Деактивация плагина
*/
	function SEOAnalyzer_deactivate(){
		wp_clear_scheduled_hook('SEOanalyzer_cron_twicedaily'); 
		return true;
	}
	register_deactivation_hook( __FILE__, 'SEOAnalyzer_deactivate' );

/**
* Удаление плагина
*/
	function SEOAnalyzer_uninstall(){
		include_once('functions/uninstall.php');
	}
	register_uninstall_hook( __FILE__, 'SEOAnalyzer_uninstall' );
	
add_action('SEOanalyzer_cron_twicedaily', 'SEOanalyzer_cron');

?>